# Advensys Insurance Finance Website

A professional, responsive React website for Advensys Insurance Finance - providing comprehensive insurance and financial services.

## Features

- **Modern React Architecture**: Built with React 18 and Vite for optimal performance
- **Responsive Design**: Mobile-first approach with beautiful layouts across all devices
- **Professional UI**: Clean, modern interface with smooth animations and transitions
- **Complete Insurance Services**: Showcasing Auto, Health, Life, Business, Property Insurance, and Financial Planning
- **Interactive Contact Forms**: Form validation with React Hook Form
- **Dynamic Navigation**: Smooth routing with React Router DOM
- **Performance Optimized**: Fast loading with optimized images and code splitting

## Technology Stack

- **Frontend**: React 18, Vite
- **Routing**: React Router DOM
- **Forms**: React Hook Form
- **Animations**: Framer Motion
- **Styling**: CSS3 with CSS Variables
- **Build Tool**: Vite
- **Package Manager**: NPM

## Getting Started

### Prerequisites

- Node.js (v16 or higher)
- NPM or Yarn

### Installation

1. Clone the repository:
   ```bash
   git clone <repository-url>
   cd AdvensysInFinance
   ```

2. Install dependencies:
   ```bash
   npm install
   ```

3. Start the development server:
   ```bash
   npm run dev
   ```

4. Open your browser and visit `http://localhost:3000`

### Available Scripts

- `npm run dev` - Start development server
- `npm run build` - Build for production
- `npm run preview` - Preview production build
- `npm run lint` - Run ESLint

## Project Structure

```
src/
├── components/
│   ├── layout/          # Header, Footer components
│   ├── sections/        # Hero, Services, About, Contact, News sections
│   └── ui/             # Reusable UI components
├── pages/              # Page components (Home, About, Services, Contact, News)
├── styles/             # Global styles and CSS files
├── assets/             # Static assets
└── utils/              # Utility functions
```

## Key Pages

- **Home**: Complete overview with hero, services, about, news, and contact sections
- **About**: Company story, mission, vision, team, and certifications
- **Services**: Detailed information about all insurance services offered
- **Contact**: Contact forms, office information, and map
- **News**: Latest news articles and industry insights

## Responsive Design

The website is fully responsive and optimized for:
- Desktop (1200px+)
- Tablet (768px - 1199px)
- Mobile (320px - 767px)

## Browser Support

- Chrome (latest)
- Firefox (latest)
- Safari (latest)
- Edge (latest)

## License

© 2024 Advensys Insurance Finance. All rights reserved.